import { jsx, jsxs } from "react/jsx-runtime";
import * as _Dropdown from "@radix-ui/react-dropdown-menu";
import { useContainer, useEditor, useValue } from "@tldraw/editor";
import { forwardRef, memo, useCallback } from "react";
import { PORTRAIT_BREAKPOINT } from "../../constants.mjs";
import { useBreakpoint } from "../../context/breakpoints.mjs";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiMenuContextProvider } from "../primitives/menus/TldrawUiMenuContext.mjs";
import { DefaultZoomMenuContent } from "./DefaultZoomMenuContent.mjs";
const DefaultZoomMenu = memo(function DefaultZoomMenu2({ children }) {
  const container = useContainer();
  const [isOpen, onOpenChange] = useMenuIsOpen("zoom menu");
  const content = children ?? /* @__PURE__ */ jsx(DefaultZoomMenuContent, {});
  return /* @__PURE__ */ jsxs(_Dropdown.Root, { dir: "ltr", open: isOpen, onOpenChange, modal: false, children: [
    /* @__PURE__ */ jsx(_Dropdown.Trigger, { asChild: true, dir: "ltr", children: /* @__PURE__ */ jsx(ZoomTriggerButton, {}) }),
    /* @__PURE__ */ jsx(_Dropdown.Portal, { container, children: /* @__PURE__ */ jsx(
      _Dropdown.Content,
      {
        className: "tlui-menu",
        side: "top",
        align: "start",
        alignOffset: 0,
        sideOffset: 8,
        collisionPadding: 4,
        children: /* @__PURE__ */ jsx(TldrawUiMenuContextProvider, { type: "menu", sourceId: "zoom-menu", children: content })
      }
    ) })
  ] });
});
const ZoomTriggerButton = forwardRef(
  function ZoomTriggerButton2(props, ref) {
    const editor = useEditor();
    const breakpoint = useBreakpoint();
    const zoom = useValue("zoom", () => editor.getZoomLevel(), [editor]);
    const msg = useTranslation();
    const handleDoubleClick = useCallback(() => {
      editor.resetZoom(editor.getViewportScreenCenter(), {
        animation: { duration: editor.options.animationMediumMs }
      });
    }, [editor]);
    return /* @__PURE__ */ jsx(
      TldrawUiButton,
      {
        ref,
        ...props,
        type: "icon",
        title: `${msg("navigation-zone.zoom")}`,
        "data-testid": "minimap.zoom-menu-button",
        className: breakpoint < PORTRAIT_BREAKPOINT.TABLET_SM ? "tlui-zoom-menu__button" : "tlui-zoom-menu__button__pct",
        onDoubleClick: handleDoubleClick,
        icon: breakpoint < PORTRAIT_BREAKPOINT.MOBILE ? "zoom-in" : void 0,
        children: breakpoint < PORTRAIT_BREAKPOINT.MOBILE ? null : /* @__PURE__ */ jsxs("span", { style: { flexGrow: 0, textAlign: "center" }, children: [
          Math.floor(zoom * 100),
          "%"
        ] })
      }
    );
  }
);
export {
  DefaultZoomMenu
};
//# sourceMappingURL=DefaultZoomMenu.mjs.map
